import { useNavigate } from 'react-router-dom';

type FormButtonProps = {
  text: string;
  type?: 'submit' | 'button';
  variant?: 'primary' | 'danger' | 'info';
  onClick?: () => void;
  toHome?: boolean;
};

export default function FormButton({
  text,
  type = 'button',
  variant = 'primary',
  onClick,
  toHome = false
}: FormButtonProps) {
  const navigate = useNavigate();

  const getClass = () => {
    switch (variant) {
      case 'danger':
        return 'remove';
      case 'info':
        return 'pdf-btn';
      default:
        return 'submit-btn';
    }
  };

  const handleClick = () => {
    if (toHome) {
      navigate('/');
    } else if (onClick) {
      onClick();
    }
  };

  return (
    <button type={type} className={getClass()} onClick={handleClick}>
      {text}
    </button>
  );
}
